---
obsidianUIMode: preview
---

The following guidelines can help Gamemasters run combat in the "theater of the mind," without the need for a gridded battle map or miniatures. This style of combat takes the emphasis away from tactical features such as distance, range, and the specific size of areas of effect. Instead, it focuses on the in-game action, the intent of the characters, and what happens in the story.

This style of combat works just like any other scene in your game. On each player's turn, you describe the current situation, the players describe their intent, and you adjudicate what happens as a result.

Theater-of-the-mind combat requires that the players trust you as the Gamemaster, knowing that you'll describe the situation and adjudicate the results of the characters' actions fairly. As the GM, you'll earn this trust by favoring the players whenever possible, and by focusing on sharing an action-packed story.

Running theater-of-the-mind combat removes agency from the players. It takes away their ability to control every aspect of how their characters move and what they do. As the GM, you can mitigate this by asking each player for their intent each turn, then helping them meet that intent. For example, a player who says "I move close to the orcs" potentially leaves too many possibilities open. So encourage the player to focus their intent more — perhaps along the lines of, "I want to position myself so that at least two orcs are within the reach of my glaive."

When playing in the theater of the mind, both you and the players must worry less about the mechanical details of the game. Instead, everyone will focus on the action and the story.

## Summary Guidelines for the GM

* Each turn, describe the situation surrounding the characters.
* Ask for the players' intent and help them achieve it.
* Be generous. Give players the benefit of the doubt.
* Use ability checks to let the characters try crazy ideas.
* Ask the players to describe interesting physical characteristics of the monsters, and use these to identify monsters during combat.
* Bring characters into the story by asking them to describe their killing blows.
* When needed, use sketches, abstract maps, or miniatures to show complicated locations and relative positions.

## Summary Guidelines for Players

* Describe your intent. What you want to accomplish?
* Use the features of the area to your advantage.
* Don't worry about specific distances. Just describe what you want to do.
* Try awesome ideas based on the details of the location.
* Describe your character's actions within the story.

## Movement, Distance, and Range

At the beginning of combat, you describe the situation, features, distances, and arrangements of the creatures in the area. Assuming a moderately sized combat area, any creature can generally move within 5 feet of any other creature, and every creature is within range of every other creature making ranged attacks. You'll make it clear whenever this isn't true, such as when an enemy is farther away or behind a front line of protective allies.

Characters with fast movement might have opportunities to move places other characters can't.

## Positioning, Opportunity Attacks, and Cover

On each player's turn, they describe how they intend to position themselves. Examples of movement in the theater of the mind might include moving next to an ally, moving next to two enemies, or staying out of reach while attacking with a polearm.

If a creature is within an enemy's reach, it will likely provoke an opportunity attack if it tries to move away from that enemy. Creatures able to disengage can do so and avoid opportunity attacks.

As you describe the features of the area, make a note of which ones can provide cover to the characters or their enemies, and how much cover.

## Areas of Effect

The following guidelines offer a rough baseline for determining the number of targets that fall within an area of effect. The circumstances of a battle can increase or decrease this number. For example, for larger monsters or monsters that are more spread out, an area of effect might target only half the normal number of creatures. For smaller monsters or monsters that are packed close together, an area of effect might include up to double the normal number of targets.

* **Tiny Area:** 1 or 2 creatures (*cloud of daggers*)
* **Small Area:** 2 creatures (*burning hands*, *thunderwave*)
* **Large Area:** 4 creatures (*cone of cold*, *fireball*)
* **Huge Area:** Everyone (*circle of death*, *earthquake*)
* **Short Line:** 2 creatures (*wall of fire*)
* **Long Line:** 3 creatures (*blade barrier*, *lightning bolt*)

Abilities like the evoker's Sculpt Spells feature can increase the number of affected enemies, usually by one or two. Likewise, an area of effect that targets both the characters and their enemies might affect more total targets — including an effect created by a character or monster willing to put allies in harm's way. If a spellcaster character wishes to place allies within an area of effect, you and the players should negotiate this before the spell is cast.

## Locations, Features, Environment, and Terrain

When first describing the combat encounter, describe notable locations, objects, environmental features, and terrain features. Write these down and keep them in front of the players if it helps them visualize the battlefield. Let the players know that they can interact with these environmental features, through such actions as swinging from magical chandeliers, climbing up obsidian cliffs to advantageous positions, or hiding behind ruined statues. If any feature or effect creates difficult terrain, let the players know how this might affect them, such as requiring that they use the Dash action to get out of the area.

## Randomly Selected Targets

Avoid biases — whether perceived or actual — by randomly selecting targets when it isn't clear which character a monster would attack. Rolling randomly for targets in the open can help build trust between you and the players, letting them know that the GM isn't picking on anyone. Monsters aren't idiots, though. If it's clear that a monster would attack a particular character, such as a wizard concentrating on a dangerous spell, the monster will do so. When this happens, just describe why the monster chose that particular character, so the players understand.

## Physical Traits and Identifying Enemies

Ask each player to describe the physical traits of a monster their character is attacking. This helps identify the monster, opens up all the players' imaginations to the battle, and helps everyone know which monster is which using in-story descriptions. Write these physical traits down on a 3×5 index card or on a dry-erase flip mat so everyone can see which monsters are in play.

## Going Big with Descriptions

Theater-of-the-mind combat can go stale if you don't continually reinforce the story of what's happening. Go big with your descriptions of the location and the action. Ask players to describe their attacks and killing blows. Between turns, describe the current situation using in-story language. These descriptions are vital to keeping the scene interesting.
